/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import dev.architectury.platform.Mod;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ClassFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class KubeJSPlugins {
    private static final List<KubeJSPlugin> LIST = new ArrayList<KubeJSPlugin>();
    private static final List<String> GLOBAL_CLASS_FILTER = new ArrayList<String>();

    public static void load(Mod mod) throws IOException {
        Optional pc;
        Optional pp = mod.findResource(new String[]{"kubejs.plugins.txt"});
        if (pp.isPresent()) {
            KubeJSPlugins.loadFromFile(Files.lines((Path)pp.get()), mod.getModId());
        }
        if ((pc = mod.findResource(new String[]{"kubejs.classfilter.txt"})).isPresent()) {
            GLOBAL_CLASS_FILTER.addAll(Files.readAllLines((Path)pc.get()));
        }
    }

    private static void loadFromFile(Stream<String> contents, String source) {
        KubeJS.LOGGER.info("Found plugin source {}", (Object)source);
        contents.map(s -> s.split("#", 2)[0].trim()).filter(s -> !s.isBlank()).flatMap(s -> {
            try {
                return Stream.of(Class.forName(s));
            }
            catch (Throwable t) {
                KubeJS.LOGGER.error("Failed to load plugin {} from source {}: {}", new Object[]{s, source, t});
                return null;
            }
        }).filter(KubeJSPlugin.class::isAssignableFrom).forEach(c -> {
            try {
                LIST.add((KubeJSPlugin)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                KubeJS.LOGGER.error("Failed to init KubeJS plugin {} from source {}: {}", new Object[]{c.getName(), source, t});
            }
        });
    }

    public static ClassFilter createClassFilter(ScriptType type) {
        ClassFilter filter = new ClassFilter();
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addClasses(type, filter));
        for (String s : GLOBAL_CLASS_FILTER) {
            if (s.length() < 2) continue;
            if (s.startsWith("+")) {
                filter.allow(s.substring(1));
                continue;
            }
            if (!s.startsWith("-")) continue;
            filter.deny(s.substring(1));
        }
        return filter;
    }

    public static void forEachPlugin(Consumer<KubeJSPlugin> callback) {
        LIST.forEach(callback);
    }
}

